/**
 * 
 */
package gov.va.genisis2.common.enums;

/**
 * The Enum CommonEnum.
 *
 * @author Getaneh Kassahun
 */

public enum CommonEnum {

	/** The no record found. */
	NO_RECORD_FOUND("No records found."), 
	
	/** The request sent. */
	REQUEST_SENT("Sent"), 
	
	/** The request denied. */
	REQUEST_DENIED("Denied"), 
	
	/** The request update. */
	REQUEST_UPDATE("Update"), 
	
	/** The request returned. */
	REQUEST_RETURNED("Returned"), 
	
	/** The request submit. */
	REQUEST_SUBMIT("Submitted"), 
	
	/** The request accepted. */
	REQUEST_ACCEPTED("RequestAccepted"), 
	
	/** The request not accepted. */
	REQUEST_NOT_ACCEPTED("RequestNotAccepted"),
	
	/** The results accepted. */
	RESULTS_ACCEPTED("ResultsAccepted"), 
	
	/** The results not accepted. */
	RESULTS_NOT_ACCEPTED("ResultsNotAccepted"), 
	
	/** The results delivered. */
	RESULTS_DELIVERED("ResultsDelivered"),
	
	/** The space. */
	SPACE(" "), 
	
	/** The unable to create request. */
	UNABLE_TO_CREATE_REQUEST("Unable to create Request. Business process failed to start."), 
	
	/** The unable to update study approval. */
	UNABLE_TO_UPDATE_STUDY_APPROVAL("Unable to update Study Approval"),
	
	/** The request draft. */
	REQUEST_DRAFT("Draft"),
	
	/** The request reject. */
	REQUEST_REJECTED("Rejected"),
	
	/** The created By. */
	REQUEST_CREATED_BY("createdBy"),
	
	/** The status description */
	STATUS_DESC("statusDescription"),
	
	/** The users */
	USERS("users"),
	
	/** The user Id */
	USER_ID("userId"),
	
	/** The user Id */
	NO_RESULT_ENTITY("No Result Exception. User Id: "),
	
	/** The user Id */
	NO_RESULT_EXCEPTION("NoResultException"),
	
	/** The Request Entity */
	REQUEST_ENTITY("request"),
	
	/** The operation */
	EMAIL_OPERATION("operation"),
	
	/** The requestorId */
	EMAIL_REQUESTOR_ID("requestorId"),
	
	/** The approverDecision */
	EMAIL_APPROVER_DECISION("approverDecision"),
	
	/** The fulfillmentDecision */
	EMAIL_FULFILLMENT_DECISION("fulfillmentDecision"),
	
	/** The resultAcceptanceDecision */
	EMAIL_RESULT_ACCEPTANCE_DECISION("resultAcceptanceDecision"),
	
	/** The approverId */
	EMAIL_APPROVER_ID("approverId"),
	
	/** The cc_users */
	EMAIL_CC_USERS("cc"),
	
	/** The emailList */
	EMAIL_LIST("emailList"),
	
	/** The Comments */
	EMAIL_COMMENTS("Comments: "),
	
	/** The Your data Request */
	EMAIL_YOUR_DATE_REQUEST("Your data request "),
	
	/** The no reply sender */
	EMAIL_NO_REPLY_SENDER("PII                     ")
	
	
	
	
	
	
	
	
	
	
	;

	/** The text. */
	private final String text;

	/**
	 * Instantiates a new common enum.
	 *
	 * @param s The s.
	 */
	private CommonEnum(String s) {
		text = s;
	}

	/**
	 * Gets the text.
	 *
	 * @return String This returns text.
	 */
	public String getText() {
		return text;
	}
}